 <div x-data="paymentModal()" x-init="init()" id="statusModal" x-cloak>
            <div
                class="fixed inset-0 z-100 flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5"
                x-show="showModal" role="dialog" @keydown.window.escape="showModal = false" 
                x-transition:enter="ease-out" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                x-transition:leave="ease-in" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            >
                <div
                    class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
                    @click="showModal = false"
                    x-show="showModal"
                    x-transition:enter="ease-out"
                    x-transition:enter-start="opacity-0"
                    x-transition:enter-end="opacity-100"
                    x-transition:leave="ease-in"
                    x-transition:leave-start="opacity-100"
                    x-transition:leave-end="opacity-0"
                ></div>

                <div
                    class="relative  w-full max-w-4xl origin-top rounded-lg bg-white p-4 dark:bg-navy-700 transition-all duration-300"
                    x-show="showModal"
                    x-transition:enter="ease-out"
                    x-transition:enter-start="opacity-0 scale-95"
                    x-transition:enter-end="opacity-100 scale-100"
                    x-transition:leave="ease-in"
                    x-transition:leave-start="opacity-100 scale-100"
                    x-transition:leave-end="opacity-0 scale-95"
                >
                    <div class="flex justify-between items-center mb-4 border-b border-slate-200 pb-4 dark:border-navy-500">
                        <h3 class="text-base font-medium text-slate-700 dark:text-navy-100">
                            {{ __('complete_payment.modal_title_complete_payment') }} #<span x-text="deliveryId"></span>
                        </h3>
                        <button
                            @click="showModal = false"
                            class="btn -mr-1.5 rounded-full p-1 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
                            aria-label="Close"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>

                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-2">
                        <div class="rounded-lg bg-slate-150 p-2 dark:bg-navy-500">
                            <div class="flex justify-between space-x-1">
                               <p class="text-xl font-semibold text-slate-700 dark:text-navy-100" x-text="'$' + deliveryAmountUsd.toFixed(2)"></p>
                                <i class="fas fa-dollar-sign text-primary dark:text-accent"></i>
                            </div>
                            <p class="mt-1 text-xs-plus">{{ __('complete_payment.label_amount_usd') }}</p>
                        </div>

                        
                        <div class="rounded-lg bg-slate-150 p-2 dark:bg-navy-500">
                            <div class="flex justify-between space-x-1">
                                <p class="text-xl font-semibold text-slate-700 dark:text-navy-100" x-text="'៛' + deliveryAmountKhr.toFixed(2)"></p>

                                <i class="fas fa-money-bill-wave text-primary dark:text-accent"></i>
                            </div>
                            <p class="mt-1 text-xs-plus">{{ __('complete_payment.label_amount_khr') }}</p>
                        </div>
                    </div>

                      <!-- Payments List -->
                     <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
                        <table class="w-full text-left">
                        <thead>
                            <tr
                            class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500"
                            >
                            <th
                                class="whitespace-nowrap px-3 py-3 font-semibold uppercase text-slate-800 dark:text-navy-100 lg:px-5"
                            >
                                {{ __('complete_payment.header_paid_to') }}
                            </th>
                            <th
                                class="whitespace-nowrap px-3 py-3 font-semibold uppercase text-slate-800 dark:text-navy-100 lg:px-5"
                            >
                                {{ __('complete_payment.header_amount') }}
                            </th>
                            <th
                                class="whitespace-nowrap px-3 py-3 font-semibold uppercase text-slate-800 dark:text-navy-100 lg:px-5"
                            >
                                {{ __('complete_payment.header_currency') }}
                            </th>
                            <th
                                class="whitespace-nowrap px-3 py-3 font-semibold uppercase text-slate-800 dark:text-navy-100 lg:px-5"
                            >
                                {{ __('complete_payment.header_payment_method') }}
                            </th>
                            <th
                                class="whitespace-nowrap px-3 py-3 font-semibold uppercase text-slate-800 dark:text-navy-100 lg:px-5"
                            >
                                {{ __('complete_payment.header_action') }}
                            </th>
                            </tr>
                        </thead>
                        <tbody>

                            <template x-for="(payment, index) in form.payments" :key="index">
                                <tr class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
                                
                                <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                                    <select
                                        x-model="payment.payment_to"
                                        class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary disabled:pointer-events-none disabled:select-none disabled:border-none disabled:bg-zinc-100 dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent dark:disabled:bg-navy-600"
                                        required
                                    >
                                        <option value="shop">{{ __('complete_payment.option_shop') }}</option>
                                        <option value="driver">{{ __('complete_payment.option_driver') }}</option>
                                        <option value="company">{{ __('complete_payment.option_company') }}</option>
                                    </select>
                                </td>
                                <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                                    <span class="relative mt-1.5 flex">
                                        <input
                                            type="number"
                                            x-model.number="payment.amount"
                                            min="0"
                                            step="0.01"
                                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                            required
                                        />
                                            <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                                    <i class="fa fa-money-bill-wave"></i>
                                                </span>
                                        </span>
                                </td>
                                <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                                    <select
                                            x-model="payment.currency"
                                            class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary disabled:pointer-events-none disabled:select-none disabled:border-none disabled:bg-zinc-100 dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent dark:disabled:bg-navy-600"
                                            required
                                        >
                                            <option value="usd">USD</option>
                                            <option value="khr">KHR</option>
                                        </select>
                                </td>
                                <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                                    <select
                                        x-model="payment.payment_method"
                                        class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary disabled:pointer-events-none disabled:select-none disabled:border-none disabled:bg-zinc-100 dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent dark:disabled:bg-navy-600"
                                        required
                                    >
                                        <option value="cash">{{ __('complete_payment.option_cash') }}</option>
                                        <option value="transfer">{{ __('complete_payment.option_transfer') }}</option>
                                    </select>
                                </td>
                                <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                                    <div
                                    class="badge space-x-2.5 rounded-full bg-primary/10 text-primary dark:bg-accent-light/15 dark:text-accent-light"
                                    >
                                    <button
                                            type="button"
                                            @click="removePayment(index)"
                                            class="text-red-600 hover:text-red-800 dark:text-red-400 dark:hover:text-red-600"
                                            title="{{ __('complete_payment.title_remove_payment') }}"
                                        >
                                            &times; #<span x-text="index + 1"></span>
                                        </button>
                                    </div>
                                </td>
                                </tr>
                            </template>

                        </tbody>
                    </table>

                    
                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-slate-700 dark:text-navy-100">{{ __('complete_payment.label_notes') }}</label>
                        <textarea
                            x-model="form.note"
                            rows="2"
                            class="form-input peer mt-1.5 w-full rounded border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="{{ __('complete_payment.placeholder_notes') }}"
                        ></textarea>
                    </div>

                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-2 mb-4">
                      <!-- Total USD -->
                        <div class="rounded-lg bg-slate-150 p-2 dark:bg-navy-500">
                            <div class="flex justify-between space-x-1">
                                <p class="text-xl font-semibold text-slate-700 dark:text-navy-100">
                                    {{ __('complete_payment.label_total_payments_usd') }}
                                </p>
                                <i class="fas fa-money-check-alt text-primary dark:text-accent"></i>
                            </div>
                            <p class="mt-1 text-xs-plus"
                            x-text="'$' + form.payments
                                .filter(p => p.currency === 'usd')
                                .reduce((sum, p) => sum + (parseFloat(p.amount) || 0), 0)
                                .toFixed(2)">
                            </p>
                        </div>

                        <!-- Total KHR -->
                        <div class="rounded-lg bg-slate-150 p-2 dark:bg-navy-500">
                            <div class="flex justify-between space-x-1">
                                <p class="text-xl font-semibold text-slate-700 dark:text-navy-100">
                                    {{ __('complete_payment.label_total_payments_khr') }}
                                </p>
                                <i class="fas fa-money-check-alt text-primary dark:text-accent"></i>
                            </div>
                            <p class="mt-1 text-xs-plus"
                            x-text="'៛' + form.payments
                                .filter(p => p.currency === 'khr')
                                .reduce((sum, p) => sum + (parseFloat(p.amount) || 0), 0)
                                .toFixed(2)">
                            </p>
                        </div>

                    </div>

                    <div class="flex justify-end space-x-2 border-t border-slate-200 pt-4 dark:border-navy-500 mt-4">

                        <button type="button"
                            @click="addPayment()"
                            class="btn py-2 bg-success/10 font-medium text-success hover:bg-success/20 focus:bg-success/20 active:bg-success/25">
                            {{ __('complete_payment.btn_add_more_payment') }}
                        </button>

                        <button type="button"
                                @click="submitPayment()"
                                :disabled="isLoading"
                                class="btn border border-primary/30 bg-primary/10 font-medium text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:border-accent-light/30 dark:bg-accent-light/10 dark:text-accent-light dark:hover:bg-accent-light/20 dark:focus:bg-accent-light/20 dark:active:bg-accent-light/25">

                                <!-- Spinner -->
                                <svg x-show="isLoading"
                                    class="w-4 h-4 animate-spin"
                                    xmlns="http://www.w3.org/2000/svg"
                                    fill="none"
                                    viewBox="0 0 24 24">
                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                    <path class="opacity-75" fill="currentColor"
                                        d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z">
                                    </path>
                                </svg>

                                <!-- Button Text -->
                                <span x-text="isLoading ? '{{ __('complete_payment.processing') }}' : '{{ __('complete_payment.btn_confirm_payment') }}'"></span>
                            </button>

                    </div>
                </div>
            </div>
        </div>

        <script>

function paymentModal() {
    return {
        showModal: false,
        deliveryId: null,
        deliveryAmountUsd: 0,
        deliveryAmountKhr: 0,
        isLoading: false, 
        form: {
            note: '',
            payments: [
                {
                    payment_to: 'driver',
                    amount: 0,
                    currency: 'usd',
                    payment_method: 'cash',

                },
            ],
        },

        init() {
            window.addEventListener('open-status-modal', (event) => {
                this.showModal = true;
                this.deliveryId = event.detail.deliveryId;
                this.deliveryAmountUsd = event.detail.amountUsd || 0;
                this.deliveryAmountKhr = event.detail.amountKhr || 0;
                this.resetForm();
            });
        },

        addPayment() {
            this.form.payments.push({
                payment_to: 'driver',
                amount: 0,
                currency: 'usd',
                payment_method: 'cash',
            });
        },

        removePayment(index) {
            if (this.form.payments.length > 1) {
                this.form.payments.splice(index, 1);
            }
        },

        resetForm() {
            this.form.payments = [
                {
                    payment_to: 'driver',
                    amount: 0,
                    currency: 'usd',
                    payment_method: 'cash',
                },
            ];
        },

        calculateTotal(currency) {
            return this.form.payments
                .filter(p => p.currency === currency)
                .reduce((sum, p) => sum + (parseFloat(p.amount) || 0), 0);
        },

        submitPayment() {
            const totalUsd = this.calculateTotal('usd');
            const totalKhr = this.calculateTotal('khr');

            // if (totalUsd.toFixed(2) != this.deliveryAmountUsd.toFixed(2)) {
            //     const usdAlert = "{{ __('complete_payment.alert_total_usd_mismatch', ['total' => ':total', 'required' => ':required']) }}";
            //     alert(
            //         usdAlert
            //             .replace(':total', totalUsd.toFixed(2))
            //             .replace(':required', this.deliveryAmountUsd.toFixed(2))
            //     );
            //     return;
            // }

            // if (totalKhr.toFixed(2) != this.deliveryAmountKhr.toFixed(2)) {
            //     const khrAlert = "{{ __('complete_payment.alert_total_khr_mismatch', ['total' => ':total', 'required' => ':required']) }}";
            //     alert(
            //         khrAlert
            //             .replace(':total', totalKhr.toFixed(2))
            //             .replace(':required', this.deliveryAmountKhr.toFixed(2))
            //     );
            //     return;
            // }

            const payload = {
                delivery_id: this.deliveryId,
                payments: this.form.payments,
                note: this.form.note,
            };
            this.isLoading = true; 

            fetch("{{ route('delivery.payment') }}", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": "{{ csrf_token() }}",
                    "X-Requested-With": "XMLHttpRequest"
                },
                body: JSON.stringify(payload),
            })
            .then(async (response) => {
                let data = await response.json();

                if (data.success) {
                    // Success
                    this.showModal = false;
                    this.resetForm();
                    $('.data-table').DataTable().ajax.reload(null, false);
                    // Show success notification
                    this.$notification({ text: "{{ __('complete_payment.msg_payment_success') }}", variant: "success", position: 'center-top', duration: 5000 });
                } else {
                    this.$notification({ text: data.message, variant: "error", position: 'center-top', duration: 5000 });
                }
            })
            .catch(error => {
                this.$notification({ text: "{{ __('complete_payment.msg_no_permission') }}", variant: "error", position: 'center-top', duration: 5000 });
            })
            .finally(() => {
                this.isLoading = false;
            });

        },
    };
}

</script>
