<!-- Full Customer Form with Styled Inputs (Create & Edit) -->

<div class="card">
    <div class="flex flex-col items-center space-y-0 border-b border-slate-200 p-2 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0">
        <h2 class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100">
            <?php echo e(isset($customer) ? __('customer.edit_customer') : __('customer.create_customer')); ?>

        </h2>
    </div>

    <div class="border border-slate-200 p-2 dark:border-navy-500 mt-3">
        <form method="POST" action="<?php echo e(isset($customer) ? route('customer.update', $customer->id) : route('customer.store')); ?>" enctype="multipart/form-data" class="space-y-4">
            <?php echo csrf_field(); ?>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(isset($customer)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                <!-- Customer Name -->
                <label class="block">
                    <span><?php echo e(__('customer.customer_name')); ?></span>
                    <span class="relative mt-1.5 flex">
                        <input name="customer_name" value="<?php echo e(old('customer_name', $customer->customer_name ?? '')); ?>"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="<?php echo e(__('customer.enter_customer_name')); ?>" type="text" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa-regular fa-user text-base"></i>
                        </span>
                    </span>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['customer_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </label>

                <!-- Phone Number -->
                <label class="block">
                    <span><?php echo e(__('customer.phone_number')); ?> <span class="text-red-500 text-xs mt-1">*</span></span>
                    <span class="relative mt-1.5 flex">
                        <input name="phone" value="<?php echo e(old('phone', $customer->phone ?? '')); ?>"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="<?php echo e(__('customer.enter_phoneNum')); ?>" type="text" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa fa-phone"></i>
                        </span>
                    </span>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </label>

                <label class="block sm:col-span-2">
                    <span><?php echo e(__('customer.type_of_customer')); ?><span class="text-red-500 text-xs mt-1">*</span></span>
                    <span class="relative mt-1.5 flex">
                        <label class="inline-flex items-center space-x-2 mr-4">
                            <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                name="type_of_customer" type="radio" value="Normal" <?php echo e(old('type_of_customer', $customer->type_of_customer ?? 'Normal') == 'Normal' ? 'checked' : ''); ?> />
                            <p>Normal</p>
                        </label>
                        <label class="inline-flex items-center space-x-2 mr-4">
                            <input class="form-radio is-outline size-5 rounded-full border-slate-400/70 before:bg-slate-500 checked:border-slate-500 hover:border-slate-500 focus:border-slate-500 dark:border-navy-400 dark:before:bg-navy-200 dark:checked:border-navy-200 dark:hover:border-navy-200 dark:focus:border-navy-200"
                                name="type_of_customer" type="radio" value="VIP" <?php echo e(old('type_of_customer', $customer->type_of_customer ?? '') == 'VIP' ? 'checked' : ''); ?> />
                            <p>VIP</p>
                        </label>
                    </span>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </label>

                <!-- MOU Price -->
                <label class="block">
                    <span><?php echo e(__('customer.mou_price')); ?></span>
                    <span class="relative mt-1.5 flex">
                        <input name="mou_price" value="<?php echo e(old('mou_price', $customer->mou_price ?? '')); ?>"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="Price Fix: 1.00" type="number" step="0.01" min="0"/>
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa fa-money-bill"></i>
                        </span>
                    </span>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['mou_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </label>

                <!-- Telegram -->
                <label class="block">
                    <span><?php echo e(__('customer.telegram')); ?></span>
                    <span class="relative mt-1.5 flex">
                        <input name="telegram" value="<?php echo e(old('telegram', $customer->telegram ?? '')); ?>"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="ex: @softcreative" type="text" />
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fab fa-telegram fa-1x"></i>
                        </span>
                    </span>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['telegram'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </label>

                <!-- Address -->
                <label class="block sm:col-span-2">
                    <span><?php echo e(__('global.address')); ?></span>
                    <span class="relative mt-1.5 flex">
                        <textarea name="address" rows="4"
                            class="form-textarea w-full resize-none rounded-lg border border-slate-300 bg-transparent p-2.5 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="<?php echo e(__('global.enterAddress')); ?>"><?php echo e(old('address', $customer->address ?? '')); ?></textarea>
                    </span>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </label>

                  <label class="block sm:col-span-2">
                    <input name="url_map" value="<?php echo e(old('url_map', $customer->url_map ?? '')); ?>" type="text" id="autocomplete" placeholder="<?php echo e(__('customer.map_url')); ?>" class="form-textarea w-full border resize-none rounded-lg p-2.5 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent">
                     
                    <input type="hidden" name="latitude" id="lat_input" />
                    <input type="hidden" name="longitude" id="lng_input" />
                    <input type="hidden" name="address_input" id="address_input" />
                  </label>
                  <?php /*
                <label class="block sm:col-span-2">
                    <div class="w-full resize-none rounded-lg border ">
                        <div id="map" class="w-full h-[300px]"></div>
                    </div>
                </label> */?>
            </div>

           
        <!-- Customer Bank Accounts -->
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($errors->any()): ?>
            <div class="mb-4 p-4 bg-red-100 text-red-700 rounded">
                <ul>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <li>- <?php echo e($error); ?></li>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                </ul>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <div x-data="bankTable()" class="mt-6">
            <h3 class="text-lg font-medium mb-2"><?php echo e(__('customer.customer_bank_account')); ?></h3>

            <table class="w-full text-left border border-slate-300 dark:border-navy-500">
                <thead class="bg-slate-100 dark:bg-navy-600">
                    <tr>
                        <th class="p-2"><?php echo e(__('customer.bank')); ?></th>
                        <th class="p-2"><?php echo e(__('customer.account_number')); ?></th>
                        <th class="p-2"><?php echo e(__('customer.bank_name')); ?></th>
                        <th class="p-2"><?php echo e(__('customer.qr_code')); ?></th>
                        <th class="p-2">
                        <button type="button" @click="addRow()"
                            class="float-end btn rounded-full bg-green-500 text-white hover:bg-green-600">
                            <?php echo e(__('customer.add_more_bank')); ?>

                        </button>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <template x-for="(bank, index) in banks" :key="index">
                        <tr>
                            <td class="p-2">
                                <select :name="'banks['+index+'][bank]'" x-model="bank.bank"
                                    class="form-select w-full rounded-full border border-slate-300 bg-transparent px-4 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent">
                                    <option value=""><?php echo e(__('customer.select_bank')); ?></option>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bankOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                                        <option value="<?php echo e($bankOption->id); ?>"
                                            :selected="bank.bank == '<?php echo e($bankOption->id); ?>'">
                                            <?php echo e($bankOption->bank_name); ?>

                                        </option>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                                </select>
                            </td>
                            <td class="p-2">
                                <span class="relative flex">
                                    <input type="text" :name="'banks['+index+'][bank_account_number]'" x-model="bank.bank_account_number"
                                        class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                        placeholder="<?php echo e(__('customer.account_number')); ?>">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fa fa-credit-card"></i>
                                    </span>
                                </span>
                            </td>
                            <td class="p-2">
                                <span class="relative flex">
                                    <input type="text" :name="'banks['+index+'][bank_account_name]'" x-model="bank.bank_account_name"
                                        class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                        placeholder="<?php echo e(__('customer.bank_name')); ?>">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fa fa-university"></i>
                                    </span>
                                </span>
                            </td>
                            <td class="p-2">
                                <input type="file" @change="handleFiles($event, index)"
                                    :name="'banks[' + index + '][qr_code]'"
                                    class="form-input w-full rounded-full border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent">

                                <div class="grid grid-cols-2 gap-2 mt-2">
                                    <template x-for="(file, qrIndex) in bank.qr_codes" :key="qrIndex">
                                        <div class="relative border rounded p-1">
                                            <img :src="file.url" class="h-16 w-16 object-contain mx-auto" alt="QR Preview">

                                            <button type="button" @click="removeFile(index, qrIndex)"
                                                class="absolute top-0 right-0 bg-red-500 text-white text-xs rounded-full px-1 hover:bg-red-600">
                                                X
                                            </button>
                                        </div>
                                    </template>
                                </div>

                                <!-- Hidden inputs for existing bank record id and existing QR code path -->
                                <template x-if="bank.id">
                                    <input type="hidden" :name="'banks[' + index + '][id]'" :value="bank.id">
                                </template>

                                <template x-for="(file, qrIndex) in bank.qr_codes" :key="'hidden-'+qrIndex">
                                    <template x-if="file.existing">
                                        <input type="hidden" :name="'banks[' + index + '][existing_qr_code]'" :value="file.name">
                                    </template>
                                </template>
                            </td>
                            <td class="p-2 text-center">
                                <button type="button" @click="removeRow(index)"
                                    class="btn rounded-full bg-red-500 text-white hover:bg-red-600">
                                    <?php echo e(__('customer.remove')); ?>

                                </button>
                            </td>
                        </tr>
                    </template>
                </tbody>
            </table>

        
        </div>
            <!-- Form Buttons -->
            <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                <a href="<?php echo e(route('customer.index')); ?>"
                    class="btn min-w-[7rem] rounded-full border border-slate-300 text-slate-700 hover:bg-slate-150 focus:bg-slate-150 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500">
                    <?php echo e(__('global.cancel')); ?>

                </a>
                <button type="submit"
                    class="btn min-w-[7rem] rounded-full bg-primary text-white hover:bg-primary-focus dark:bg-accent dark:hover:bg-accent-focus ml-2">
                    <?php echo e(isset($customer) ? __('global.update') : __('global.save')); ?>

                </button>
            </div>
        </form>
    </div>
</div>


<script>
    let map;
    let marker;
    let autocomplete;
    let geocoder;

    function hideKeyboardShortcutsPopup() {
      const popup = document.querySelector(
        '.gm-ui-hover-effect[aria-label="Keyboard shortcuts"]'
      );
      if (popup) popup.style.display = "none";
    }

    function initMap() {
      const defaultPos = { lat: 11.5564, lng: 104.9282 };

      map = new google.maps.Map(document.getElementById("map"), {
        center: defaultPos,
        zoom: 13,
        keyboardShortcuts: false,
        gestureHandling: "greedy", // optional, can be 'none' or 'greedy'
      });

      // Make sure popup is hidden after map loads and on drag
      map.addListener("tilesloaded", () => {
        hideKeyboardShortcutsPopup();
      });
      map.addListener("drag", () => {
        hideKeyboardShortcutsPopup();
      });

      geocoder = new google.maps.Geocoder();

      marker = new google.maps.Marker({
        position: defaultPos,
        map: map,
        draggable: true,
      });

      // Update info when marker dragged
      marker.addListener("dragend", function () {
        const pos = marker.getPosition();
        updatePosition(pos.lat(), pos.lng());
        geocodeLatLng(pos);
        hideKeyboardShortcutsPopup();
      });

      // Setup autocomplete input
      autocomplete = new google.maps.places.Autocomplete(
        document.getElementById("autocomplete"),
        { types: ["geocode"] }
      );

      autocomplete.addListener("place_changed", function () {
        const place = autocomplete.getPlace();
        if (!place.geometry) {
          alert("No details available for input: '" + place.name + "'");
          return;
        }

        const lat = place.geometry.location.lat();
        const lng = place.geometry.location.lng();

        map.setCenter({ lat, lng });
        map.setZoom(15);

        marker.setPosition({ lat, lng });

        updatePosition(lat, lng);

        document.getElementById("address").innerText =
          place.formatted_address || "";
        document.getElementById("address_input").value =
          place.formatted_address || "";

        hideKeyboardShortcutsPopup();
      });

      // Initialize with default position info
      updatePosition(defaultPos.lat, defaultPos.lng);
      geocodeLatLng(new google.maps.LatLng(defaultPos.lat, defaultPos.lng));
      hideKeyboardShortcutsPopup();

      // Prevent keyboard shortcuts popup from '?' key
      const mapDiv = document.getElementById("map");
      mapDiv.addEventListener("keydown", function (e) {
        if (e.key === "?" || e.key === "Shift" || e.key === "Slash") {
          e.preventDefault();
        }
      });
    }

    function updatePosition(lat, lng) {
      document.getElementById("lat").innerText = lat.toFixed(6);
      document.getElementById("lng").innerText = lng.toFixed(6);

      document.getElementById("lat_input").value = lat;
      document.getElementById("lng_input").value = lng;
    }

    function geocodeLatLng(latlng) {
      geocoder.geocode({ location: latlng }, (results, status) => {
        if (status === "OK") {
          if (results[0]) {
            document.getElementById("address").innerText =
              results[0].formatted_address;
            document.getElementById("address_input").value =
              results[0].formatted_address;
            document.getElementById("autocomplete").value =
              results[0].formatted_address;
          } else {
            document.getElementById("address").innerText = "No address found";
            document.getElementById("address_input").value = "";
          }
        } else {
          console.error("Geocoder failed due to: " + status);
        }
      });
    }
  </script>



<script>
     function bankTable() {
        return {
            banks: <?php echo json_encode(old('banks', $banksData ?? [[
                'bank' => '', 'bank_account_number' => '', 'bank_account_name' => '', 'qr_codes' => []
            ]])); ?>,

            addRow() {
                this.banks.push({ bank: '', bank_account_number: '', bank_account_name: '', qr_codes: [] });
            },
            removeRow(index) {
                this.banks.splice(index, 1);
            },
            handleFiles(event, bankIndex) {
                const selectedFiles = Array.from(event.target.files);
                selectedFiles.forEach(file => {
                    this.banks[bankIndex].qr_codes.push({
                        file: file,
                        url: URL.createObjectURL(file),
                        name: file.name,
                        existing: false,
                    });
                });
            },
            removeFile(bankIndex, qrIndex) {
                if (!this.banks[bankIndex].qr_codes[qrIndex].existing) {
                    URL.revokeObjectURL(this.banks[bankIndex].qr_codes[qrIndex].url);
                }
                this.banks[bankIndex].qr_codes.splice(qrIndex, 1);
            }
        }
    }


</script>

  <script
    async
    defer
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCy7zpvws9obEDQAqrs2SvThCYfouA-9wY&libraries=places&callback=initMap"
  ></script>

<?php /**PATH /www/wwwroot/pdex.softcreative.us/resources/views/pages/customers/_form.blade.php ENDPATH**/ ?>