<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => 'Delivery View','isHeaderBlur' => 'false','isSidebarOpen' => 'true','headerSticky' => 'false','hasMinSidebar' => 'false']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Delivery View','is-header-blur' => 'false','is-sidebar-open' => 'true','header-sticky' => 'false','has-min-sidebar' => 'false']); ?>



    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">Delivery</h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                    <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">List</a>
                    <svg x-ignore xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </li>
                <li>View</li>
            </ul>

            <!-- Back Button -->
            <div class="ml-auto">
                <a href="<?php echo e(route('delivery.index')); ?>" class="btn bg-primary text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">Back</a>
            </div>
        </div>

        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">
            <div>
                <div class=" p-2 mt-3">
                   
                <div class="grid grid-cols-12 gap-4 sm:gap-5 lg:gap-6">
                    <div class="col-span-12 lg:col-span-4">
                        <div class="card p-4 sm:p-5">
                           <div class="flex items-center space-x-4 mb-4 border-b border-slate-200 dark:border-navy-500 pb-4 w-full">
                                <div class="alert flex items-center justify-between rounded-lg bg-slate-100 p-3 dark:bg-navy-500 w-full">
                                    <p id="clipboardContent1" class="truncate">
                                        <?php echo e($delivery->code); ?>

                                    </p>
                                    <button
                                        class="btn h-6 shrink-0 rounded bg-primary/20 px-2 text-xs text-white active:bg-white/25 dark:bg-primary-100 dark:text-navy-100 dark:hover:bg-navy-500 dark:active:bg-navy-700"
                                        @click="$clipboard({
                                            content:document.querySelector('#clipboardContent1').innerText,
                                            success:()=>$notification({text:'Code Copied',variant:'dark'}),
                                            error:()=>$notification({text:'Error',variant:'error'})
                                        })"
                                    >
                                        Copy
                                    </button>
                                </div>
                            </div>


                        <ol class="timeline max-w-sm">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $delivery->statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $color = match(strtolower($status->status)) {
                                        'booking' => 'bg-warning',
                                        'in_progress' => 'bg-primary',
                                        'completed' => 'bg-success',
                                        'cancelled', 'returned' => 'bg-error',
                                        default => 'bg-slate-300',
                                    };
                                ?>

                                <li class="timeline-item">
                                    <div class="timeline-item-point rounded-full <?php echo e($color); ?>">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(strtolower($status->status) == 'completed'): ?>
                                            <span class="inline-flex h-full w-full animate-ping rounded-full <?php echo e($color); ?> opacity-80"></span>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>

                                    <div class="timeline-item-content flex-1 pl-4 sm:pl-8">
                                        <div class="flex flex-col justify-between pb-2 sm:flex-row sm:pb-0">
                                            <p class="pb-2 font-medium leading-none text-slate-600 dark:text-navy-100 sm:pb-0">
                                                <?php echo e($status->status); ?> | <?php echo e($status->changedBy->name ?? 'System'); ?>

                                            </p>
                                            <span class="text-xs text-slate-400 dark:text-navy-300">
                                                <?php echo e($status->created_at->diffForHumans()); ?>

                                            </span>
                                        </div>
                                        <p class="py-1">
                                             <div class="text-xs text-slate-400 dark:text-navy-300"><?php echo e($status->changed_at); ?></div>
                                             <?php echo e($status->note ?? 'Status updated.'); ?>

                                        </p>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </ol>
                        </div>

                        <div class="card mt-4 p-4 sm:p-5">
                            <div id="print-area" style="width: 80mm; padding: 5mm; font-family: monospace;">
                                <h2 style="text-align: center;">Delivery Invoice</h2>

                                <p>Invoice #: <strong><?php echo e($delivery->code); ?></strong></p>
                                <p>Shop Name: <?php echo e($delivery->customer?->customer_name); ?></p>
                                <p>Date: <?php echo e($delivery->pickup_at); ?></p>

                                <table style="width: 100%; margin-top: 10px;">
                                    <thead>
                                        <tr>
                                            <th style="text-align: left;">Receiver </th>
                                            <th style="text-align: right;">Amount USD</th>
                                            <th style="text-align: right;">Amount KHR</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    
                                            <tr>
                                                <td><?php echo e($delivery->receiver_phone); ?></td>
                                                <td style="text-align: right;"><?php echo e($delivery->amount_usd); ?></td>
                                                <td style="text-align: right;"><?php echo e($delivery->amount_khr); ?></td>
                                            </tr>
                                             <tr>
                                                <td colspan="3">Address: <?php echo e($delivery->receiver_address); ?></td>
                                            </tr>
                                    
                                    </tbody>
                                </table>

                                <hr>
                                <p style="text-align: right;"><strong>Total: <?php echo e($delivery->amount_usd); ?> USD | <?php echo e($delivery->amount_khr); ?> KHR </strong></p>

                        
                                <div style="text-align: center; margin-top: 10px;">
                                    <img 
                                        src="data:image/png;base64,<?php echo e($qrCodeBase64); ?>" 
                                        alt="QR Code" 
                                        style="display: block; margin: 0 auto; width: 80px;"
                                    >

                                    <p style="font-size: 12px;">Scan for details</p>
                                </div>
                                <p style="text-align: center; font-size: 12px;">Thank you!</p>
                            </div>

                        </div>

                    </div>
                    


                           



                    <div class="col-span-12 lg:col-span-8">
                        <div class="card">
                        <div
                            class="flex flex-col items-center space-y-4 border-b border-slate-200 p-4 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0 sm:px-5"
                        >
                            <h2
                            class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100"
                            >
                               <?php echo e($delivery->customer?->customer_name ?? 'Unknown Customer'); ?> | <?php echo e($delivery->customer->phone ?? 'No Phone'); ?> | <?php echo e($delivery->created_at); ?>

                            </h2>
                            <div class="flex justify-center space-x-2">
                            <button
                            onclick="printInvoice()"
                                class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                            >
                                Print Receipt
                            </button>
                            </div>
                        </div>
                        <div class="p-4 sm:p-5">
                            <div class="flex flex-col">
                          
                               
                                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
                                    <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                        <div class="flex justify-between space-x-1">
                                            <p class="text-xl font-semibold text-slate-700 dark:text-navy-100">
                                                $<?php echo e(number_format($delivery->delivery_price, 2)); ?>

                                            </p>
                                            <i class="fas fa-truck text-primary dark:text-accent"></i>
                                        </div>
                                        <p class="mt-1 text-xs-plus">Delivery Price</p>
                                    </div>

                                    
                                    <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                        <div class="flex justify-between space-x-1">
                                            <p class="text-xl font-semibold text-slate-700 dark:text-navy-100">
                                                $<?php echo e($delivery->amount_usd); ?>

                                            </p>
                                            <i class="fas fa-dollar-sign text-primary dark:text-accent"></i>
                                        </div>
                                        <p class="mt-1 text-xs-plus">Amount USD</p>
                                    </div>

                                
                                    <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                        <div class="flex justify-between space-x-1">
                                            <p class="text-xl font-semibold text-slate-700 dark:text-navy-100">
                                                ៛<?php echo e($delivery->amount_khr); ?>

                                            </p>
                                            <i class="fas fa-money-bill-wave text-primary dark:text-accent"></i>
                                        </div>
                                        <p class="mt-1 text-xs-plus">Amount KHR</p>
                                    </div>

                                     <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                        <div class="flex justify-between space-x-1">
                                            <p class="text-xl font-semibold text-slate-700 dark:text-navy-100">
                                              <?php echo e($delivery->deliveryBy->display_name ?? 'Not Yet Assign'); ?>

                                            </p>
                                            <i class="fas fa-truck text-primary dark:text-accent"></i>
                                        </div>
                                        <p class="mt-1 text-xs-plus">Delivery By</p>
                                    </div>


                                </div>


                            </div>
                            <div class="my-7 h-px bg-slate-200 dark:bg-navy-500"></div>
                            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                           
                                <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                    <p class="text-sm text-slate-600 dark:text-navy-100">Receiver Phone</p>
                                    <p class="mt-1 text-base font-semibold text-slate-700 dark:text-navy-100">
                                        <?php echo e($delivery->receiver_phone ?? 'No Phone'); ?>

                                    </p>
                                </div>

                                <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                    <p class="text-sm text-slate-600 dark:text-navy-100">Receiver Address</p>
                                    <p class="mt-1 text-base font-semibold text-slate-700 dark:text-navy-100">
                                        <?php echo e($delivery->receiver_address ?? 'No Address'); ?>

                                    </p>
                                </div>
                            </div>

                            <table class="is-hoverable w-full text-left mt-5">
                                    <thead>
                                        <tr>
                                       <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                            Date
                                        </th>
                                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                            Paid To
                                        </th>
                                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                            Amount
                                        </th>
                                         <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                            Currency
                                        </th>
                                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                            Payment Method
                                        </th>
                                        <th class="whitespace-nowrap rounded-r-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                            Noted
                                        </th>
                                      
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $delivery->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="px-4 py-2 text-slate-600 dark:text-navy-200 ">
                                                   <?php echo e($payment->created_at->format('Y-m-d H:i:s')); ?>

                                                </td>
                                               <td class="px-4 py-2 text-slate-600 dark:text-navy-200 ">
                                                    <?php echo e(ucfirst($payment->payment_to)); ?>

                                                </td>
                                                <td class="px-4 py-2 text-slate-600 dark:text-navy-200 ">
                                                    <?php echo e(number_format($payment->amount, 2)); ?>

                                                </td>
                                                <td class="px-4 py-2 text-slate-600 dark:text-navy-200">
                                                    <?php echo e($payment->currency); ?>

                                                </td>
                                                <td class="px-4 py-2 text-slate-600 dark:text-navy-200">
                                                    <?php echo e($payment->payment_method); ?>

                                                </td>
                                                <td class="px-4 py-2 text-slate-600 dark:text-navy-200">
                                                    <?php echo e($payment->note); ?>

                                                </td>
                                             
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </tbody>
                                </table>
                            


                         



                        </div>

                        </div>
                    </div>

                    </div>


                </div>
            </div>
        </div>
    </main>


 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>

<?php /**PATH /www/wwwroot/pdex.softcreative.us/resources/views/pages/delivery/view.blade.php ENDPATH**/ ?>