<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => ''.e(__('EOD_sum.page_title_eod')).'','isHeaderBlur' => 'false','isSidebarOpen' => 'true']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => ''.e(__('EOD_sum.page_title_eod')).'','is-header-blur' => 'false','is-sidebar-open' => 'true']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>


<main class="main-content w-full px-[var(--margin-x)] pb-8 print:px-4">
    
    <!-- Header -->
    <div class="flex items-center justify-between py-4">
        <h2 class="text-xl font-semibold text-slate-800">
            <?php echo e(__('EOD_sum.page_title_eod')); ?>

        </h2>

        <button onclick="window.print()"
            class="btn btn-sm bg-primary text-white print:hidden">
            <?php echo e(__('EOD_sum.btn_print')); ?>

        </button>
    </div>

    <div class="card p-4 space-y-6">

     <form method="GET" action="<?php echo e(route('summaryIncomeFromDelivery.index')); ?>" class="flex items-end gap-3">
        <div x-data="{ dateValue: '<?php echo e(request('date')); ?>' }" class="w-72">
            <label class="block">
                <span class="text-sm font-medium text-slate-700"><?php echo e(__('EOD_sum.label_filter_date')); ?></span>

                <div class="relative mt-1.5">
                    <!-- Calendar Icon -->
                    <span
                        class="pointer-events-none absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"
                    >
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5"
                            fill="none" viewBox="0 0 24 24"
                            stroke="currentColor" stroke-width="1.5">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                    </span>

                    <!-- Date Input -->
                    <input
                        name="date"
                        x-model="dateValue"
                        x-init="
                            flatpickr($el, {
                                mode: 'range',
                                dateFormat: 'Y-m-d',
                                defaultDate: dateValue ? dateValue.split(' to ') : null,
                                onChange(_, dateStr) {
                                    dateValue = dateStr;
                                }
                            });
                        "
                        type="text"
                        placeholder="<?php echo e(__('EOD_sum.placeholder_date_range')); ?>"
                        class="form-input w-full rounded-lg border border-slate-300
                            bg-transparent px-3 py-2 pl-10 pr-3
                            focus:border-primary focus:ring-primary"
                    />
                </div>
            </label>
        </div>

        <!-- Apply Button -->
        <button
            type="submit"
            class="btn h-[38px] bg-primary text-white px-5 rounded-lg
                hover:bg-primary-focus transition"
        >
            <?php echo e(__('EOD_sum.btn_apply')); ?>

        </button>
    </form>



        <!-- SECTION 1: DELIVERY SUMMARY -->
        <table class="eod-table">
            <thead>
                <tr>
                    <th colspan="8" class="eod-title">
                        <?php echo e(__('EOD_sum.header_daily_delivery')); ?>

                    </th>
                </tr>
                <tr>
                    <th rowspan="2"><?php echo e(__('EOD_sum.col_total_package')); ?></th>
                    <th rowspan="2"><?php echo e(__('EOD_sum.col_in_stock')); ?></th>
                    <th rowspan="2"><?php echo e(__('EOD_sum.col_in_progress')); ?></th>
                    <th rowspan="2"><?php echo e(__('EOD_sum.col_canceled')); ?></th>
                    <th rowspan="2"><?php echo e(__('EOD_sum.col_completed')); ?></th>
                    <th colspan="2"><?php echo e(__('EOD_sum.header_amount')); ?></th>
                </tr>
                <tr>
                    <th>USD</th>
                    <th>KHR</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?php echo e($grandTotal['total_package'] ?? 0); ?></td>
                    <td><?php echo e($grandTotal['in_stock'] ?? 0); ?></td>
                    <td><?php echo e($grandTotal['assigned'] ?? 0); ?></td>
                    <td><?php echo e($grandTotal['canceled'] ?? 0); ?></td>
                    <td><?php echo e($grandTotal['completed'] ?? 0); ?></td>
                    <td><?php echo e(number_format($grandTotal['total_usd'] ?? 0, 2)); ?></td>
                    <td><?php echo e(number_format($grandTotal['total_khr'] ?? 0)); ?></td>
                </tr>
            </tbody>
        </table>

        <!-- SECTION 2: DRIVER SUMMARY -->
        <table class="eod-table">
            <thead>
                <tr>
                    <th colspan="8" class="eod-title">
                        <?php echo e(__('EOD_sum.header_daily_driver')); ?>

                    </th>
                </tr>
                <tr>
                    <th colspan="4"><?php echo e(__('EOD_sum.col_total_drivers')); ?></th>
                    <th colspan="2"> <?php echo e(__('EOD_sum.col_amount_collected')); ?></th>
                    <th colspan="2"><?php echo e(__('EOD_sum.col_paid_to_company')); ?></th>
                </tr>
                <tr>
                    <th colspan="4"></th>
                    <th>USD</th>
                    <th>KHR</th>
                    <th>USD</th>
                    <th>KHR</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td colspan="4"><?php echo e($dailySummaryDriver->total_driver ?? 0); ?></td>
                    <td><?php echo e($dailySummaryDriver->total_amount_usd ?? 0); ?></td>
                    <td><?php echo e($dailySummaryDriver->total_amount_khr ?? 0); ?></td>
                    <td><?php echo e($dailySummaryDriver->driver_collect_usd ?? 0); ?></td>
                    <td><?php echo e($dailySummaryDriver->driver_collect_khr ?? 0); ?></td>
                </tr>
            </tbody>
        </table>

        <!-- SECTION 3: SHOP SUMMARY -->
        <table class="eod-table">
            <thead>
                <tr>
                    <th colspan="8" class="eod-title">
                        <?php echo e(__('EOD_sum.header_daily_shop')); ?>

                    </th>
                </tr>
                <tr>
                    <th colspan="2"><?php echo e(__('EOD_sum.col_total_shops')); ?></th>
                    <th colspan="2"><?php echo e(__('EOD_sum.col_service_fee')); ?></th>
                    <th colspan="2"><?php echo e(__('EOD_sum.col_amount_collected')); ?></th>
                    <th colspan="2"><?php echo e(__('EOD_sum.col_paid_to_shop')); ?></th>
                </tr>
                <tr>
                    <th colspan="2"></th>
                    <th colspan="2"></th>
                    <th>USD</th>
                    <th>KHR</th>
                    <th>USD</th>
                    <th>KHR</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td colspan="2"><?php echo e($grandTotal['total_shop'] ?? 0); ?></td>
                    <td colspan="2"><?php echo e(number_format($grandTotal['service_fee'] ?? 0, 2)); ?></td>
                    <td><?php echo e(number_format($grandTotal['usd'] ?? 0, 2)); ?></td>
                    <td><?php echo e(number_format($grandTotal['khr']?? 0)); ?></td>
                    <td><?php echo e(number_format($grandTotal['paid_usd'] ?? 0, 2)); ?></td>
                    <td><?php echo e(number_format($grandTotal['paid_khr'] ?? 0)); ?></td>
                </tr>
            </tbody>
        </table>

    </div>
<style>
    .eod-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 13px;
}

.eod-table th,
.eod-table td {
    border: 1px solid #cbd5e1;
    padding: 6px;
    text-align: center;
}

.eod-table thead {
    background-color: #f1f5f9;
}

.eod-title {
    text-align: left !important;
    font-weight: 600;
    background-color: #e2e8f0;
}

</style>
</main>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php /**PATH /www/wwwroot/pdex.softcreative.us/resources/views/pages/summary-shop/eod.blade.php ENDPATH**/ ?>