<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Car Delivery Invoice</title>

<!-- Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Battambang:wght@400;700&family=Roboto&display=swap" rel="stylesheet">

<style>
/* =========================
   GLOBAL
========================= */
body {
    font-family: 'Battambang','Roboto',sans-serif;
    background: #ccc;
    margin: 0;
}

page {
    width: 21cm;
    min-height: 29.7cm;
    margin: 1cm auto;
    background: #fff;
    padding: 1cm;
    display: block;
}

h1,h2,h3 {
    margin: 4px 0;
}

.text-center { text-align: center; }
.text-right { text-align: right; }
.bold { font-weight: bold; }

/* =========================
   TABLE
========================= */
table {
    width: 100%;
    border-collapse: collapse;
    font-size: 14px;
}

th, td {
    border: 1px solid #000;
    padding: 6px;
}

.no-border td {
    border: none;
}
.invoice-header {
    display: flex;
    align-items: center;
    justify-content: center; /* keep center */
    position: relative;
    margin-bottom: 15px;
}

.invoice-header .location {
    text-align: center;
}

.invoice-header .logo {
    position: absolute;
    left: 0;
}

.invoice-header .logo img {
    width: 180px;
    float: left;
}

/* =========================
   PRINT
========================= */

@media print {
    body {
        background: #fff;
        margin: 0;
        padding: 0;
    }

    page {
        margin: 0;
        padding: 1cm;
        box-shadow: none;
        page-break-after: avoid;     /* KEY */
        page-break-before: avoid;    /* KEY */
        page-break-inside: avoid;    /* KEY */
    }

    table, tr, td, th {
        page-break-inside: avoid;    /* prevent table split */
    }

    @page {
        size: A4;
        margin: 0;
    }
}

</style>
</head>

<body>

<page>

   <!-- ================= HEADER ================= -->
    <div class="invoice-header">
        <!-- Center location -->
        <div class="location">
            <h2><?php echo e($currentBranch->name); ?></h2>
            <div><?php echo e($currentBranch->address); ?></div>
            <div>Tel: <?php echo e($currentBranch->phone); ?></div>
        </div>

        <!-- Right logo -->
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($currentBranch->logo): ?>
            <div class="logo">
                <img src="<?php echo e(asset('storage/'.$currentBranch->logo)); ?>" alt="Logo">
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

    <hr style="border:1px solid #000; margin:10px 0">

    <h3 class="text-center">
       DELIVERY INVOICE  
        <br>
        <small>(Import by <?php echo e($summary->shipping_method); ?>)</small>
    </h3>

    <!-- ================= INVOICE INFO ================= -->
    <table class="no-border" style="margin-top:10px">
        <tr>
            <td>
                <strong>Driver:</strong> <?php echo e($car->display_name); ?> / <strong>Tel.</strong> <?php echo e($car->phone); ?>

            </td>
            <td class="text-right">
                <strong>Invoice Date:</strong> <?php echo e(now()->format('d-m-Y')); ?> <br>
            </td>
        </tr>
    </table>

    <!-- ================= DELIVERY LIST ================= -->
    <table style="margin-top:10px">
        <thead>
            <tr class="bold text-center">
                <th>No</th>
                <th>Delivery Code</th>
                <th>From</th>
                <th>To</th>
                <th>PCS</th>
                <th>Weight (KG)</th>
                <th>Amount (USD)</th>
            </tr>
        </thead>
        <tbody>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $deliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>

            <tr>
                <td class="text-center"><?php echo e($index + 1); ?></td>
                <td><?php echo e($delivery->delivery?->code); ?></td>
                <td><?php echo e(optional($delivery->delivery?->fromWarehouse)->name); ?></td>
                <td><?php echo e(optional($delivery->delivery?->toWarehouse)->name); ?></td>
                <td class="text-center"><?php echo e($delivery->delivery?->pcs ?? '0'); ?></td>
                <td class="text-center"><?php echo e($delivery->delivery?->kg ?? '0'); ?></td>
                <td class="text-right">
                    <?php echo e(number_format($delivery->delivery?->amount_usd ?? '0' , 2)); ?>

                </td>
            </tr>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>

        </tbody>
        <tfoot>
            <tr>
                <td class="text-right bold" colspan="6">Total</td>
                <td class="text-right bold">
                    <?php echo e(number_format($deliveries->sum(fn ($item) => $item->delivery?->amount_usd ?? 0), 2)); ?>


                </td>
            </tr>
        </tfoot>
    </table>


    <!-- ================= SIGNATURE ================= -->
    <table class="no-border" style="margin-top:50px">
        <tr>
            <td class="text-center" style="width:50%">
                ___________________________<br>
                Driver Signature
            </td>
            <td class="text-center">
                ___________________________<br>
                Accounting Signature
            </td>
        </tr>
    </table>

</page>

</body>
</html>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        window.print();
        window.onafterprint = function () {
            window.location.href = "<?php echo e(route('in-transit.index')); ?>";
        };
    });
</script><?php /**PATH /www/wwwroot/pdex.softcreative.us/resources/views/pages/booking/in-transit-invoice.blade.php ENDPATH**/ ?>