<div x-data="cancelModal()" x-init="setselectStatus(<?php echo \Illuminate\Support\Js::from($statusOptions)->toHtml() ?>)" id="statusModal" x-cloak>

            <div
                class="fixed inset-0 z-100 flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5"
                x-show="showModal" role="dialog" @keydown.window.escape="showModal = false" 
                x-transition:enter="ease-out" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
                x-transition:leave="ease-in" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            >
                <div
                    class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
                    @click="showModal = false"
                    x-show="showModal"
                    x-transition:enter="ease-out"
                    x-transition:enter-start="opacity-0"
                    x-transition:enter-end="opacity-100"
                    x-transition:leave="ease-in"
                    x-transition:leave-start="opacity-100"
                    x-transition:leave-end="opacity-0"
                ></div>

                <div
                    class="relative  w-full max-w-lg origin-top rounded-lg bg-white  dark:bg-navy-700 transition-all duration-300"
                    x-show="showModal"
                    x-transition:enter="ease-out"
                    x-transition:enter-start="opacity-0 scale-95"
                    x-transition:enter-end="opacity-100 scale-100"
                    x-transition:leave="ease-in"
                    x-transition:leave-start="opacity-100 scale-100"
                    x-transition:leave-end="opacity-0 scale-95"
                >
                   <div class="flex justify-between items-center mb-4 border-b border-slate-200 pb-4 dark:border-navy-500 
                        bg-gray-50 dark:bg-gray-900/30 rounded px-4 py-3">
                        <h3 class="text-base font-medium text-gray-700 dark:text-gray-200">
                            Driver <span x-text="driver"></span> : #<span x-text="deliveryId"></span>
                        </h3>
                        <button
                            @click="showModal = false"
                            class="btn -mr-1.5 rounded-full p-1 hover:bg-gray-200/20 focus:bg-gray-200/20 active:bg-gray-300/25 dark:hover:bg-gray-300/20 dark:focus:bg-gray-300/20 dark:active:bg-red-300/25"
                            aria-label="Close"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-600 dark:text-gray-300" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>

                    <div class="p-4">
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-slate-700 dark:text-navy-100"> Status</label>
                            <select
                                x-model="form.status"
                                class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary disabled:pointer-events-none disabled:select-none disabled:border-none disabled:bg-zinc-100 dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent dark:disabled:bg-navy-600"
                                required
                            >
                                <option value="">-- Select status --</option>
                                <template x-for="st in selectStatus" :key="st.value">
                                    <option :value="st.value" x-text="st.label"></option>
                                </template>
                            </select>

                        </div>

                        
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-slate-700 dark:text-navy-100">Notes</label>
                        <textarea
                            x-model="form.note"
                            rows="2"
                            class="form-input peer mt-1.5 w-full rounded border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="Optional notes"
                        ></textarea>

                        </div>

                    </div>

                   <div class="flex p-4 justify-end space-x-2 border-t border-slate-200 pt-4 dark:border-navy-500 mt-4">
                        <button type="button"
                            @click="showModal = false"
                            class="btn border border-primary/30 bg-primary/10 font-medium text-primary 
                                hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 
                                dark:border-accent-light/30 dark:bg-accent-light/10 
                                dark:text-accent-light dark:hover:bg-accent-light/20 
                                dark:focus:bg-accent-light/20 dark:active:bg-accent-light/25">
                            Close
                        </button>

                        <button type="button"
                                @click="submitPayment()"
                                :disabled="isLoading"
                                class="btn border border-primary/30 bg-primary/10 font-medium text-primary hover:bg-primary/20 focus:bg-primary/20 active:bg-primary/25 dark:border-accent-light/30 dark:bg-accent-light/10 dark:text-accent-light dark:hover:bg-accent-light/20 dark:focus:bg-accent-light/20 dark:active:bg-accent-light/25">

                                <!-- Spinner -->
                                <svg x-show="isLoading"
                                    class="w-4 h-4 animate-spin"
                                    xmlns="http://www.w3.org/2000/svg"
                                    fill="none"
                                    viewBox="0 0 24 24">
                                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                    <path class="opacity-75" fill="currentColor"
                                        d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z">
                                    </path>
                                </svg>

                                <!-- Button Text -->
                                <span x-text="isLoading ? 'Processing...' : 'Confirm'"></span>
                            </button>

                    </div>

                </div>
            </div>
        </div>

       <script>
function cancelModal() {
    return {
        showModal: false,
        deliveryId: null,
        driver: null,
        isLoading: false, 
        selectStatus: [], 
        form: {
            note: '',
            status: '',
        },

        init() {
            window.addEventListener('open-status-cancel-modal', (event) => {
               // console.log(event.detail);
                this.showModal = true;
                this.driver = event.detail.driver;
                this.deliveryId = event.detail.deliveryId;
                this.form.status = event.detail.statusId || '';
                this.form.note = event.detail.note || '';
            });
        },

        setselectStatus(selectStatus) {
            this.selectStatus = selectStatus;
        },

        submitPayment() {
            if (!this.form.status) {
                alert('Please select a status.');
                return;
            }

            if (this.form.status === 'other' && !this.form.note.trim()) {
                alert('Please provide a note for "Other" reason.');
                return;
            }

            const payload = {
                delivery_id: this.deliveryId,
                status: this.form.status,
                note: this.form.note,
            };
            this.isLoading = true; 

            fetch("<?php echo e(route('inTransit.status')); ?>", {
                  method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                        "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>",
                        "X-Requested-With": "XMLHttpRequest"
                    },
                    body: JSON.stringify(payload),
            })
                 .then(async (response) => {
                 
                    let data = await response.json();
               //     console.log(data);

                    if (data.success) {
                        this.showModal = false;
                        $('.data-table').DataTable().ajax.reload(null, false);
                        this.$notification({ text: data.message, variant: "success", position: 'center-top', duration: 5000 });
                    } else {
                        this.$notification({ text: data.message, variant: "error", position: 'center-top', duration: 5000 });
                    }
                })
                .catch((error) => {
                //    console.log('e'+error);
                    this.$notification({ text: 'failed due to network or server error.', variant: "error", position: 'center-top', duration: 5000 });
                })
                .finally(() => {
                    this.isLoading = false;
                });

        },
    };
}

</script>
<?php /**PATH /www/wwwroot/pdex.softcreative.us/resources/views/pages/booking/in-transit-modal.blade.php ENDPATH**/ ?>