<?php if (isset($component)) { $__componentOriginal4619374cef299e94fd7263111d0abc69 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4619374cef299e94fd7263111d0abc69 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-layout','data' => ['title' => 'Customers book pickup','isHeaderBlur' => 'false','isSidebarOpen' => 'true','headerSticky' => 'false','hasMinSidebar' => 'false']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Customers book pickup','is-header-blur' => 'false','is-sidebar-open' => 'true','header-sticky' => 'false','has-min-sidebar' => 'false']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>


     <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">
                <?php echo e(__('pickUp.book_pickup')); ?>

            </h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                    <a
                        class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent"
                        href="#"
                    ><?php echo e(__('global.list')); ?></a>
                    <svg
                        x-ignore
                        xmlns="http://www.w3.org/2000/svg"
                        class="size-4"
                        fill="none"
                        viewBox="0 0 24 24"
                        stroke="currentColor"
                    >
                        <path
                            stroke-linecap="round"
                            stroke-linejoin="round"
                            stroke-width="2"
                            d="M9 5l7 7-7 7"
                        />
                    </svg>
                </li>
                <li><?php echo e(__('global.all')); ?></li>
            </ul>

            <!-- Add New Button -->
            <div class="ml-auto">
                <a href="<?php echo e(route('book-pickup.create')); ?>"
                    class="btn bg-primary text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                    <?php echo e(__('global.addNew')); ?>

                </a>
            </div>
        </div>

         <div class="grid grid-cols-1 sm:grid-cols-3 lg:grid-cols-6 gap-4 mt-4 card p-2">
            <div x-data="{ dateValue: '' }">
                <label class="block">
                    <span class="text-sm font-medium text-slate-700 dark:text-navy-100"><?php echo e(__('pickUp.book_pickup_date')); ?></span>
                    <label class="relative flex mt-1.5">
                        <input
                            id="entryFilter"
                            name="entry_at"
                            x-model="dateValue"
                            x-init="
                                flatpickr($el, {
                                    mode: 'range',
                                    dateFormat: 'Y-m-d',
                                    defaultDate: null,
                                    onChange: function(selectedDates, dateStr, instance) {
                                        dateValue = dateStr;
                                    }
                                });
                            "
                            class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 pr-10 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="<?php echo e(__('pickUp.choose_date')); ?>..."
                            type="text"
                            x-ref="entryDateInput"
                        />

                        <span
                            class="pointer-events-none absolute left-0 flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="size-5 transition-colors duration-200" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                        </span>

                        <button
                            type="button"
                            x-show="dateValue"
                            @click="dateValue = ''; $refs.entryDateInput._flatpickr.clear()"
                            class="absolute right-2 top-2 text-slate-400 hover:text-red-500 focus:outline-none"
                            title="Clear"
                        >
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24"
                                stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </label>
                </label>
            </div>

         </div>

        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">

          <div>
            <div class="card p-2 mt-3">
              <div class="gridjs-wrapper is-scrollbar-hidden min-w-full overflow-x-auto">
                <table class="is-hoverable w-full text-left data-table">
                  <thead>
                    <tr>
                      <th class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-1 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-1">
                        <?php echo e(__('global.no')); ?></sup></th>
                        <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        <?php echo e(__('pickUp.book_pickup')); ?>

                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        <?php echo e(__('customer.customers')); ?>

                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        <?php echo e(__('global.phoneNumber')); ?>

                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        <?php echo e(__('pickUp.total_package')); ?>

                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                       <?php echo e(__('customer.map')); ?>

                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                       <?php echo e(__('pickUp.image')); ?>

                      </th>
                       <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                       <?php echo e(__('pickUp.pickup_by')); ?>

                      </th>
                      <th class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        <?php echo e(__('global.status')); ?></th>
                    </tr>
                  </thead>
                  <tbody class="gridjs-tbody">
                   
                  </tbody>
                </table>
              </div>

          
            </div>
          </div>


      </main>


   <?php echo $__env->make('pages.customers.pickup.assigned-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>


 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $attributes = $__attributesOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__attributesOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4619374cef299e94fd7263111d0abc69)): ?>
<?php $component = $__componentOriginal4619374cef299e94fd7263111d0abc69; ?>
<?php unset($__componentOriginal4619374cef299e94fd7263111d0abc69); ?>
<?php endif; ?>


<?php echo $__env->yieldPushContent('scripts'); ?>
<script>
     window.currentUserRole = "<?php echo e(auth()->user()->getRoleNames()->first()); ?>";
$(function () {
    $('.data-table').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        autoWidth: false,
        ajax: {
            url: "<?php echo e(route('book-pickup.index')); ?>",
            data: function (d) {
                d.entry_at = $('#entryFilter').val();
            }
        },
        columns: [
             { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },

            { data: 'date', name: 'date'},
            { data: 'customer_name', name: 'customer_name' },
            { data: 'phone', name: 'phone' },
            { data: 'total_package', name: 'total_package'},
            {
                data: 'url_map', name: 'url_map',
                render: function(data) {
                    if (!data) return '-';

                    return `
                        <div class="badge space-x-2.5 rounded-full bg-error/10 text-success dark:bg-error-200">
                            <a href="${data}" target="_blank" class="inline-flex items-center space-x-1 text-primary hover:underline">
                                <i class="fas fa-map-marker-alt text-red-500"></i>
                                <span>View Map</span>
                            </a>
                        </div>
                    `;
                }
            },
            { 
                data: 'images', 
                name: 'images', 
                orderable: false, 
                searchable: false 
            },
            { data: 'pickup', name: 'pickup' },
            {
                data: 'status',
                name: 'status',
                render: function (data, type, row) {
                     const isCustomer = window.currentUserRole === 'customer';
                      const isClickable = !isCustomer;
                    const cursorClass = isClickable ? 'cursor-pointer' : 'cursor-not-allowed opacity-50';

                    const bookPickUpId = row.id;
                    const note = JSON.stringify(row.note || '');
                    const pickupBy = JSON.stringify(row.pickup_by || '');

                    const onclick = isClickable
                        ? `window.dispatchEvent(new CustomEvent('open-status-cancel-modal', { detail: { bookPickUpId: ${bookPickUpId}, note: ${note}, pickupBy: ${pickupBy} }}))`
                        : `alert('This recode do not allow to click.')`;

                    return `
                        <div 
                            class="${cursorClass} badge space-x-2.5 rounded-full bg-primary/10 text-success dark:bg-primary dark:bg-primary-light" 
                            style="white-space: nowrap"
                            onclick="${onclick.replace(/"/g, '&quot;')}"
                        >
                            ${data}
                        </div>
                    `;
                }
            },
        ],
        dom: "<'flex flex-col md:flex-row justify-between items-center mb-4'lf>tr<'flex flex-col md:flex-row justify-between items-center mt-4'ip>",
        language: {
            lengthMenu: "<?php echo e(__('global.show')); ?> _MENU_ <?php echo e(__('global.show')); ?>",
            search: "<?php echo e(__('global.search')); ?>",
            zeroRecords: "<?php echo e(__('global.search_not_found')); ?>",
            info: "<?php echo e(__('global.showing')); ?> _START_ <?php echo e(__('global.To')); ?> _END_ <?php echo e(__('global.Of')); ?> _TOTAL_ <?php echo e(__('global.entry')); ?>",
            infoEmpty: "<?php echo e(__('global.showing')); ?> 0 <?php echo e(__('global.To')); ?> 0 <?php echo e(__('global.Of')); ?> 0 <?php echo e(__('global.entry')); ?>",
            infoFiltered: "(<?php echo e(__('global.filter_from')); ?> _MAX_ <?php echo e(__('global.total_entries')); ?>)",
             paginate: {
                 previous: `
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"></path>
                    </svg>
                `,
                next: `
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
                    </svg>
                `
            }
        },
         createdRow: function (row, data, dataIndex) {

            $(row).addClass(' hover:bg-slate-50 dark:hover:bg-navy-800');
            $('td', row).addClass('whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500');

        },
        drawCallback: function () {

            $('.dataTables_paginate .paginate_button')
            .addClass('flex mr-1 ml-1 h-8 min-w-[2rem] items-center justify-center bg-primary rounded-full bg-slate-150 px-3 leading-tight transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90');

            $('.dataTables_paginate .paginate_button.previous, .dataTables_paginate .paginate_button.next')
                .addClass('flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:text-navy-200 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90')
                .removeClass('px-3 min-w-[2rem]'); 

        }
    });

    $('.dataTables_filter input').addClass('form-input w-full rounded-full border border-slate-300 bg-transparent px-4 py-1 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent');
    $('.dataTables_filter label').addClass('flex items-center space-x-2');
    $('.dataTables_length select').addClass('form-select rounded-full border border-slate-300 bg-white px-3 py-1 pr-6 text-xs-plus hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:text-navy-100 dark:hover:border-navy-400 dark:focus:border-accent');
    $('.dataTables_length label').addClass('flex items-center space-x-2');


});

$('#entryFilter').on('change', function () {
    $('.data-table').DataTable().ajax.reload();
});


</script>

<?php /**PATH /www/wwwroot/pdex.softcreative.us/resources/views/pages/customers/pickup/index.blade.php ENDPATH**/ ?>