<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Batch Invoice</title>

   <style>
        * {
            box-sizing: border-box;
        }

        body {
            font-family: 'Battambang', 'Noto Sans Khmer', Arial, sans-serif;
            margin: 0;
            padding: 0;
            font-size: 12px;
            color: #000;
            background: #fff;
        }

        /* PAGE WRAPPER (IMPORTANT) */
        .page {
            display: flex;
            justify-content: center;
            margin-top: 40px;
        }

        .print-area {
            width: 80mm;
            padding: 4mm;
        }

        p {
            margin: 2px 0;
            line-height: 1.35;
        }

        h3 {
            margin: 4px 0 2px;
            font-size: 14px;
        }

        .text-center { text-align: center; }
        .text-left { text-align: left; }
        .text-right { text-align: right; }

        .divider {
            border-top: 1px dashed #000;
            margin: 6px 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        td {
            padding: 3px 0;
        }

        /* HEADER */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }

        .header-left {
            width: 60%;
        }

        .header-right {
            width: 40%;
            text-align: right;
        }

        .header-right img {
            width: 70px;
        }

        .section-title {
            font-weight: bold;
            margin-top: 4px;
        }

        .total-row {
            font-weight: bold;
            font-size: 13px;
        }

        /* PRINT SETTINGS */
        @media print {
            @page {
                size: 80mm auto;
                margin: 0;
            }

            body {
                margin: 0;
                padding: 0;
            }

            .page {
                justify-content: center;
            }

            .print-area,
            table,
            tr,
            td,
            p,
            div {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $deliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
<div class="page">
    <div class="print-area">

        <!-- HEADER -->
        <div class="header">
            <div class="header-left">
                <h3>Shop</h3>
                <p>
                    <strong>Name:</strong><br>
                    <?php echo e($delivery->customer?->customer_name); ?><br>
                    <?php echo e($delivery->customer?->phone); ?>

                </p>
            </div>

            <?php
                $tracking = route('tracking.search');
                $qrCode = base64_encode(
                    QrCode::format('png')->size(200)->generate(
                        $tracking . '?code=' . $delivery->code
                    )
                );
            ?>

            <div class="header-right">
                <img src="data:image/png;base64,<?php echo e($qrCode); ?>" alt="QR Code">
                <p style="font-size: 9px;"><?php echo e($delivery->code); ?></p>
            </div>
        </div>

        <div class="divider"></div>

        <!-- RECEIVER -->
        <div>
            <p class="section-title">
                Receiver — <?php echo e(\Carbon\Carbon::parse($delivery->created_at)->format('d/m/Y h:i A')); ?>

            </p>
            <p><strong>Phone:</strong> <?php echo e($delivery->receiver_phone); ?></p>
            <p><strong>Address:</strong> <?php echo e($delivery->receiver_address); ?></p>
            <p><strong>Note:</strong> <?php echo e($delivery->note ?? 'N/A'); ?></p>
        </div>

        <div class="divider"></div>

        <!-- TOTAL -->
        <table>
            <tr class="total-row">
                <td>Total</td>
                <td class="text-right">
                    USD $<?php echo e(number_format($delivery->amount_usd, 2)); ?> |
                    KHR ៛<?php echo e(number_format($delivery->amount_khr, 0)); ?>

                </td>
            </tr>
        </table>

        <div class="divider"></div>

        <!-- FOOTER -->
        <p class="text-center" style="margin-top: 6px; font-size: 11px;">
            Thank You!
        </p>

    </div>
</div>
<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
<script>
    window.onload = function () {
        window.print();
    };

    window.onafterprint = function () {
        window.history.back();
    };
</script>

</body>
</html>
<?php /**PATH /www/wwwroot/pdex.softcreative.us/resources/views/pages/delivery/inquiry/print-batch-invoice.blade.php ENDPATH**/ ?>